using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace WindowsGame1
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Sprite tlo;
        Sprite pilka;
        public static int szerokosc = 800;
        public static int wysokosc = 600;
        Texture2D teksturaGracza1;
        GraczAI gracz1;
        GraczAI gracz2;
        AudioEngine audioEngine;
        WaveBank waveBank;
        SoundBank soundBank;
        SpriteFont font;
        TablicaWynikow tablicaWynikow;
        Effect efektDrgania;
        float intensywnosc = 0.5f;
        public static int timer = 0;
        double czestoscZmian = 0.1;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferWidth = szerokosc;
            graphics.PreferredBackBufferHeight = wysokosc;
            this.Window.Title = "Pong";
            this.IsMouseVisible = true;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            Services.AddService(typeof(SpriteBatch), spriteBatch);

            tlo = new Sprite(Content.Load<Texture2D>("Pong"), new Vector2(0f, 0f), new Vector2(szerokosc, wysokosc));
            pilka = new Sprite(Content.Load<Texture2D>("Pilka"), new Vector2(szerokosc / 2, wysokosc / 2), new Vector2(szerokosc * 0.04f, szerokosc * 0.04f), new Vector2(3, 3), new Rectangle(0, 0, szerokosc, wysokosc));
            teksturaGracza1 = Content.Load<Texture2D>("Gracz");
            gracz1 = new GraczAI(this, teksturaGracza1, new Vector2(0, wysokosc / 2), new Vector2(szerokosc * 0.03f, wysokosc * 0.09f), new Rectangle(0, 0, Convert.ToInt32(szerokosc * 0.03f), wysokosc), false);
            gracz1.UstawKlawisze(Keys.W, Keys.S);
            gracz2 = new GraczAI(this, teksturaGracza1, new Vector2(szerokosc * 0.97f, wysokosc / 2), new Vector2(szerokosc * 0.03f, wysokosc * 0.09f), new Rectangle(0, 0, Convert.ToInt32(szerokosc * 0.03f), wysokosc), true);
            gracz2.UstawKlawisze(Keys.Up, Keys.Down);
            gracz1.odlegloscReakcji = 350;
            gracz2.odlegloscReakcji = 350;
            this.Components.Add(gracz1);
            this.Components.Add(gracz2);
            audioEngine = new AudioEngine(@"Content\MySound.xgs");
            waveBank = new WaveBank(audioEngine, @"Content\MySound.xwb");
            soundBank = new SoundBank(audioEngine, @"Content\MySound.xsb");

            Song tloMuzyczne = Content.Load<Song>("Waltz of the flowers");
            MediaPlayer.Play(tloMuzyczne);
            MediaPlayer.IsRepeating = true;

            font = Content.Load<SpriteFont>("MyFont");
            tablicaWynikow = new TablicaWynikow(this, font, new Vector2(szerokosc / 3, 20), new Vector2(2 * szerokosc / 3, 20));
            this.Components.Add(tablicaWynikow);

            efektDrgania = Content.Load<Effect>("EfektDrgania");
            efektDrgania.Parameters["intensywnosc"].SetValue(intensywnosc);
            tablicaWynikow.efektDrgania = efektDrgania;
        }


        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            gracz1.polozeniePilki = pilka.polozenie;
            gracz1.predkoscPilki = pilka.predkosc;
            if (gracz1.ObslugaKolizji(pilka)) soundBank.PlayCue("chimes");
            gracz2.polozeniePilki = pilka.polozenie;
            gracz2.predkoscPilki = pilka.predkosc;
            if (gracz2.ObslugaKolizji(pilka)) soundBank.PlayCue("chimes");
            if (pilka.ZmienPolozenie((float)gameTime.ElapsedGameTime.TotalMilliseconds / 10, tablicaWynikow)) soundBank.PlayCue("chimes");

            RegulacjaGlosnosci();
            ZmienIloscGraczy();

            if (timer > 0)
            {
                tablicaWynikow.timer = timer;
                timer--;
                float intensywnosc = 2 * (float)Math.Sin(czestoscZmian * gameTime.TotalGameTime.TotalMilliseconds);
                efektDrgania.Parameters["intensywnosc"].SetValue(intensywnosc);
            }

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.CornflowerBlue);

            if (timer == 0)
            {
                spriteBatch.Begin();
                spriteBatch.Draw(tlo.tekstura, tlo.ObszarOgraniczajacy, Color.White);
                spriteBatch.Draw(pilka.tekstura, pilka.ObszarOgraniczajacy, Color.Red);
                spriteBatch.End();
            }
            else
            {
                spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.AlphaBlend);
                efektDrgania.CurrentTechnique.Passes[0].Apply();
                spriteBatch.Draw(tlo.tekstura, tlo.ObszarOgraniczajacy, Color.White);
                spriteBatch.Draw(pilka.tekstura, pilka.ObszarOgraniczajacy, Color.Red);
                spriteBatch.End();
            }

            base.Draw(gameTime);
        }

        private void RegulacjaGlosnosci()
        {
            KeyboardState stanKlawiatury = Keyboard.GetState();

            if (stanKlawiatury.IsKeyDown(Keys.M))
                MediaPlayer.IsMuted = !MediaPlayer.IsMuted;
            if (stanKlawiatury.IsKeyDown(Keys.Add))
                MediaPlayer.Volume += 0.05f;
            if (stanKlawiatury.IsKeyDown(Keys.Subtract))
                MediaPlayer.Volume -= 0.05f;
        }

        private void ZmienIloscGraczy()
        {
            KeyboardState stanKlawiatury = Keyboard.GetState();

            if (stanKlawiatury.IsKeyDown(Keys.D0) || stanKlawiatury.IsKeyDown(Keys.NumPad0))
            {
                ResetujUstawienia(0);
                this.Window.Title = "Pong, bez graczy AI";
            }
            if (stanKlawiatury.IsKeyDown(Keys.D1) || stanKlawiatury.IsKeyDown(Keys.NumPad1))
            {
                ResetujUstawienia(1);
                this.Window.Title = "Pong, jeden gracz AI";
            }
            if (stanKlawiatury.IsKeyDown(Keys.D2) || stanKlawiatury.IsKeyDown(Keys.NumPad2))
            {
                ResetujUstawienia(2);
                this.Window.Title = "Pong, dwch graczy AI";
            }
        }

        private void ResetujUstawienia(int iloscGraczyKomputerowych)
        {
            tablicaWynikow.Resetuj();
            pilka.polozenie = new Vector2(Game1.szerokosc / 2, Game1.wysokosc / 2);
            pilka.predkosc = new Vector2(3, 3);
            switch (iloscGraczyKomputerowych)
            {
                case 2:
                    gracz1.czyGraczKomputerowy = true;
                    gracz2.czyGraczKomputerowy = true;
                    break;
                case 1:
                    gracz1.czyGraczKomputerowy = false;
                    gracz2.czyGraczKomputerowy = true;
                    break;
                default:
                    gracz1.czyGraczKomputerowy = false;
                    gracz2.czyGraczKomputerowy = false;
                    break;
            }
        }
    }
}
